﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Amyuni.PDFCreator;

namespace WindowsFormsApplication31
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            CenterToScreen();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            button1.Enabled = false;

            // instantiate the main PDF document object
            IacDocument pdf = new IacDocument();

			//Constants for Activation codes
			const string strLicenseTo = "Amyuni PDF OCR Module Evaluation";
			const string strActivationCode = "07EFCDAB010001005A888A7BF8902FAF8584F56239FDFC32187F682FED02E9D517E3742DFA4B738C0A";
			
			//set license key This is needed only with licensed version
			pdf.SetLicenseKey(strLicenseTo, strActivationCode);

            // create a file stream and open the file from the stream
            FileStream fIn = new FileStream("OCR Module Developer Manual.pdf", FileMode.Open, FileAccess.Read);
            pdf.Open(fIn, "");

            // rasterize the first 3 pages (Optional)
            pdf.RasterizePageRange(1, pdf.PageCount, 200, IacRasterizeColorOption.acColorOptionGray, IacImageCompressionConstants.acCompressionDefault);

            // apply OCR on the first 3 pages
            pdf.OCRPageRange(1, 3, "eng", IacOCROptions.acOCROptionVisibleText);

            // save the resulting PDF to a stream
            FileStream fOut = new FileStream("rasterized.pdf", FileMode.OpenOrCreate, FileAccess.ReadWrite);
            pdf.Save(fOut, IacFileSaveOption.acFileSaveView);

            // cleanup
            pdf.Dispose();
            fIn.Close();
            fOut.Close();

            MessageBox.Show("Done.");
            
            button1.Enabled = true;
        }
    }
}
